/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.viewer;

import java.io.File;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.viewer.ViewerAttributeRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class TexLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Combo choiceCombo;
    private Text commandField;
    private Text argumentField;
    private Button commandBrowserButton;
    private ViewerAttributeRegistry registry = new ViewerAttributeRegistry();
    private DDEGroup ddeCloseGroup;
    private DDEGroup ddeViewGroup;
    private boolean isUpdatingFields = false;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 4);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.createVerticalSpacer(composite, 3);
        Label choiceLabel = new Label(composite, 16384);
        choiceLabel.setText(TexlipsePlugin.getResourceString("launchTabChoiceLabel"));
        choiceLabel.setToolTipText(TexlipsePlugin.getResourceString("launchTabChoiceTooltip"));
        choiceLabel.setLayoutData((Object)new GridData());
        this.choiceCombo = new Combo(composite, 4);
        this.choiceCombo.setToolTipText(TexlipsePlugin.getResourceString("launchTabChoiceTooltip"));
        GridData cgd = new GridData();
        cgd.horizontalSpan = 2;
        this.choiceCombo.setLayoutData((Object)cgd);
        String[] viewers = this.registry.getViewerList();
        this.choiceCombo.setItems(viewers);
        this.choiceCombo.select(this.registry.getActiveViewerIndex(viewers));
        this.choiceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TexLaunchConfigurationTab.this.updateFields(TexLaunchConfigurationTab.this.choiceCombo.getSelectionIndex());
            }
        });
        this.createVerticalSpacer(composite, 3);
        Label commandLabel = new Label(composite, 16384);
        commandLabel.setText(TexlipsePlugin.getResourceString("launchTabCommandLabel"));
        commandLabel.setToolTipText(TexlipsePlugin.getResourceString("launchTabCommandTooltip"));
        commandLabel.setLayoutData((Object)new GridData());
        this.commandField = new Text(composite, 2116);
        this.commandField.setToolTipText(TexlipsePlugin.getResourceString("launchTabCommandTooltip"));
        this.commandField.setLayoutData((Object)new GridData(768));
        this.commandField.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                File f = new File(TexLaunchConfigurationTab.this.commandField.getText());
                if (!f.exists()) {
                    TexLaunchConfigurationTab.this.setErrorMessage(TexlipsePlugin.getResourceString("launchTabCommandError"));
                }
            }
        });
        this.commandField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TexLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.commandBrowserButton = new Button(composite, 8);
        this.commandBrowserButton.setText(JFaceResources.getString((String)"openChange"));
        this.commandBrowserButton.setToolTipText(TexlipsePlugin.getResourceString("launchTabCommandTooltip"));
        this.commandBrowserButton.setLayoutData((Object)new GridData());
        this.commandBrowserButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File f;
                FileDialog dialog = new FileDialog(TexLaunchConfigurationTab.this.commandBrowserButton.getShell(), 4096);
                String file = dialog.open();
                if (file != null && file.length() > 0 && (f = new File(file)).exists()) {
                    TexLaunchConfigurationTab.this.commandField.setText(file);
                }
            }
        });
        this.createVerticalSpacer(composite, 3);
        Label argumentLabel = new Label(composite, 16384);
        argumentLabel.setText(TexlipsePlugin.getResourceString("launchTabArgumentsLabel"));
        argumentLabel.setToolTipText(TexlipsePlugin.getResourceString("launchTabArgumentsTooltip"));
        argumentLabel.setLayoutData((Object)new GridData());
        this.argumentField = new Text(composite, 2116);
        this.argumentField.setToolTipText(TexlipsePlugin.getResourceString("launchTabArgumentsTooltip"));
        this.argumentField.setLayoutData((Object)new GridData(768));
        this.argumentField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TexLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.addDDEGroups(composite);
        this.setControl((Control)composite);
    }

    private void updateFields(int selectionIndex) {
        this.isUpdatingFields = true;
        this.registry.setCommand(this.commandField.getText());
        this.registry.setArguments(this.argumentField.getText());
        this.registry.setDDEViewCommand(this.ddeViewGroup.command.getText());
        this.registry.setDDEViewServer(this.ddeViewGroup.server.getText());
        this.registry.setDDEViewTopic(this.ddeViewGroup.topic.getText());
        this.registry.setDDECloseCommand(this.ddeCloseGroup.command.getText());
        this.registry.setDDECloseServer(this.ddeCloseGroup.server.getText());
        this.registry.setDDECloseTopic(this.ddeCloseGroup.topic.getText());
        String viewer = this.choiceCombo.getItem(selectionIndex);
        this.registry.setActiveViewer(viewer);
        String command = this.registry.getCommand();
        if (command == null) {
            command = "";
        }
        this.commandField.setText(command);
        String arguments = this.registry.getArguments();
        if (arguments == null) {
            arguments = "";
        }
        this.argumentField.setText(arguments);
        this.ddeViewGroup.command.setText(this.registry.getDDEViewCommand());
        this.ddeViewGroup.server.setText(this.registry.getDDEViewServer());
        this.ddeViewGroup.topic.setText(this.registry.getDDEViewTopic());
        this.ddeCloseGroup.command.setText(this.registry.getDDECloseCommand());
        this.ddeCloseGroup.server.setText(this.registry.getDDECloseServer());
        this.ddeCloseGroup.topic.setText(this.registry.getDDECloseTopic());
        this.updateLaunchConfigurationDialog();
        this.isUpdatingFields = false;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            String viewer = configuration.getAttribute("viewerCurrent", this.registry.getActiveViewer());
            this.registry.setActiveViewer(viewer);
            configuration.setAttribute("viewerCurrent", viewer);
            configuration.setAttribute(String.valueOf(viewer) + ".command", this.registry.getCommand());
            configuration.setAttribute(String.valueOf(viewer) + ".arguments", this.registry.getArguments());
            configuration.setAttribute(String.valueOf(viewer) + ".ddeViewCommand", this.registry.getDDEViewCommand());
            configuration.setAttribute(String.valueOf(viewer) + ".ddeViewServer", this.registry.getDDEViewServer());
            configuration.setAttribute(String.valueOf(viewer) + ".ddeViewTopic", this.registry.getDDEViewTopic());
            configuration.setAttribute(String.valueOf(viewer) + ".ddeCloseCommand", this.registry.getDDECloseCommand());
            configuration.setAttribute(String.valueOf(viewer) + ".ddeCloseServer", this.registry.getDDECloseServer());
            configuration.setAttribute(String.valueOf(viewer) + ".ddeCloseTopic", this.registry.getDDECloseTopic());
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Initializing launch configuration", e);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.registry.setValues(configuration.getAttributes());
            String[] viewers = this.registry.getViewerList();
            this.choiceCombo.setItems(viewers);
            this.choiceCombo.select(this.registry.getActiveViewerIndex(viewers));
            this.commandField.setText(this.registry.getCommand());
            this.argumentField.setText(this.registry.getArguments());
            this.ddeViewGroup.command.setText(this.registry.getDDEViewCommand());
            this.ddeViewGroup.server.setText(this.registry.getDDEViewServer());
            this.ddeViewGroup.topic.setText(this.registry.getDDEViewTopic());
            this.ddeCloseGroup.command.setText(this.registry.getDDECloseCommand());
            this.ddeCloseGroup.server.setText(this.registry.getDDECloseServer());
            this.ddeCloseGroup.topic.setText(this.registry.getDDECloseTopic());
        }
        catch (CoreException e) {
            TexlipsePlugin.log("Reading launch configuration", e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.registry.setActiveViewer(this.choiceCombo.getItem(this.choiceCombo.getSelectionIndex()));
        this.registry.setCommand(this.commandField.getText());
        this.registry.setArguments(this.argumentField.getText());
        this.registry.setDDEViewCommand(this.ddeViewGroup.command.getText());
        this.registry.setDDEViewServer(this.ddeViewGroup.server.getText());
        this.registry.setDDEViewTopic(this.ddeViewGroup.topic.getText());
        this.registry.setDDECloseCommand(this.ddeCloseGroup.command.getText());
        this.registry.setDDECloseServer(this.ddeCloseGroup.server.getText());
        this.registry.setDDECloseTopic(this.ddeCloseGroup.topic.getText());
        configuration.setAttributes(this.registry.asMap());
    }

    public Image getImage() {
        return TexlipsePlugin.getImage("sample");
    }

    public String getName() {
        return TexlipsePlugin.getResourceString("launchTabTitle");
    }

    protected void updateLaunchConfigurationDialog() {
        if (!this.isUpdatingFields) {
            super.updateLaunchConfigurationDialog();
        }
    }

    private void addDDEGroups(Composite composite) {
        this.ddeViewGroup = new DDEGroup(composite, TexlipsePlugin.getResourceString("preferenceViewerDDEViewLabel"), TexlipsePlugin.getResourceString("preferenceViewerDDEViewTooltip"));
        this.ddeCloseGroup = new DDEGroup(composite, TexlipsePlugin.getResourceString("preferenceViewerDDECloseLabel"), TexlipsePlugin.getResourceString("preferenceViewerDDECloseTooltip"));
        if (Platform.getOS().equals("win32")) {
            this.ddeViewGroup.setVisible(true);
            this.ddeCloseGroup.setVisible(true);
        }
    }

    private class DDEGroup
    extends Composite {
        public Text command;
        public Text server;
        public Text topic;

        public DDEGroup(Composite parent, String name, String toolTip) {
            super(parent, 0);
            this.setLayoutData(new GridData(768));
            ((GridData)this.getLayoutData()).horizontalSpan = 2;
            this.setLayout((Layout)new GridLayout());
            Group group = new Group((Composite)this, 4);
            group.setText(name);
            group.setToolTipText(toolTip);
            group.setLayoutData((Object)new GridData(768));
            group.setLayout((Layout)new GridLayout(4, false));
            Label ddeCommandLabel = new Label((Composite)group, 16384);
            ddeCommandLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerDDECommandLabel"));
            ddeCommandLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDECommandTooltip"));
            ddeCommandLabel.setLayoutData((Object)new GridData());
            this.command = new Text((Composite)group, 2052);
            this.command.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDECommandTooltip"));
            this.command.setLayoutData((Object)new GridData(768));
            this.command.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TexLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            });
            ((GridData)this.command.getLayoutData()).horizontalSpan = 3;
            Label ddeServerLabel = new Label((Composite)group, 16384);
            ddeServerLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerDDEServerLabel"));
            ddeServerLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDEServerTooltip"));
            ddeServerLabel.setLayoutData((Object)new GridData());
            this.server = new Text((Composite)group, 2052);
            this.server.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDEServerTooltip"));
            this.server.setLayoutData((Object)new GridData(768));
            this.server.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TexLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            });
            Label ddeTopicLabel = new Label((Composite)group, 16384);
            ddeTopicLabel.setText(TexlipsePlugin.getResourceString("preferenceViewerDDETopicLabel"));
            ddeTopicLabel.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDETopicTooltip"));
            ddeTopicLabel.setLayoutData((Object)new GridData());
            this.topic = new Text((Composite)group, 2052);
            this.topic.setToolTipText(TexlipsePlugin.getResourceString("preferenceViewerDDETopicTooltip"));
            this.topic.setLayoutData((Object)new GridData(768));
            this.topic.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TexLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.setVisible(false);
        }
    }
}

