/*
    definitions of global objects used in xetal,
    Copyright (C) 1991 Raphael Cerf (e-mail: cerf@ens.ens.fr)

    This file is part of xetal.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * global definitions
 */

int mode=0;	/* current mode 0: normal, 1: math */
int verbatim=0;	/* verbatim mode */
int d_ok=1;	/* display flag */
long lineno=0L;	/* current line in source text */
long total_lines=0L;/* nb of lines already handled */
long charpos=0L;/* last char read */
long linepos=0L;/* last \n read */
long oldlpos=0L;/* old value of linepos */

int n_nl, N;/* n_nl : numerotation flag, N : interval of numerotation */
int n_formule=0;/* nb of formulas */
long c_skipped=0L;/* nb of characters skipped */
char c_fill=' ';/* replacement character */
char s_accent='\\';/* character to put before accent */

/*
 * options flags
 */
int d_anything, d_error;
int d_accent, d_bl, d_bls, d_command, d_comment, d_fname;
int d_macrodef, d_math, d_mot, d_nl, d_operator, d_punct;
int d_report, d_slashed, d_special, d_text, d_unknown;
int d_warning, do_fill, do_fill_acco, do_fill_slash, do_incl;

FILE *devnull;  /* rubbish-bin */
int n_ionly=-1;	/* nb of ionly files; -1 : no includeonly instruction */
char *if_name[F_MAX];	/* includeonly_files */
char *f_name;	/* name of current file */
FILE **f_in;	/* input stream */
char S[O_LGTH]; /* output buffer */

int n_envrt=0;  /* nb of envrt names */
char *(envrt[M_ENVRT]); /* envrt handled as math */

int n_symbol;	/* nb of known symbols */
symbol_t symbol[M_SYMBOL]; /* symbol list */

int n_adsymbol;	/* nb of added symbols */
symbol_t adsymbol[M_SYMBOL];/* list of added symbols */
