/*
    Copyright (C) 1995-1997
	Rainer Schnitker, Heeper Str. 283, 33607 Bielefeld
	email: rainer@mathematik.uni-bielefeld.de

    All rights reserved
*/

#include "rsxnt.h"

#define MAXERROR 115

static nt2emx_error[MAXERROR] = {
    0	    ,
    ENOSYS  ,
    ENOENT  ,
    ENOTDIR ,
    ENFILE  ,
    EACCES  ,
    EBADF   ,
    EFAULT  ,
    ENOMEM  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EACCES  ,
    EINVAL  ,
    ENOMEM  ,
    ENOTDIR ,
    ENOTDIR ,
    ENOTDIR ,
    EMFILE  ,
    EACCES  ,
    EINVAL  ,
    EAGAIN  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    ESPIPE  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EFAULT  ,
    EFAULT  ,
    EFAULT  ,
    EACCES  ,
    EACCES  ,
    EINVAL  ,
    0	    ,
    EINVAL  ,
    0	    ,
    EPERM   ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    ENOSYS  ,
    EINVAL  ,
    EBADF   ,
    EINVAL  ,
    EPERM   ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    EEXIST  ,
    0	    ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    0	    ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EINVAL  ,
    EPIPE   ,
    EACCES  ,
    ENOSPC  ,
    ENOSPC  ,
    ENOSPC  ,
    EBADF
};

int _rsxnt_get_last_errno(void)
{
    DWORD sys_errno = GetLastError() & 0xffff;

    if (sys_errno > MAXERROR)
	sys_errno = EINVAL;
    else
	sys_errno = nt2emx_error[sys_errno];

#ifdef EMX_SYS_LIB
  errno = sys_errno;
  return -1;
#else
  return -(sys_errno);
#endif
}

int _rsxnt_errno(int sys_errno)
{
#ifdef EMX_SYS_LIB
  errno = sys_errno;
  return -1;
#else
  return -(sys_errno);
#endif
}

