/* close.c (rsxnt) -- Copyright (c) 1996-1997 Rainer Schnitker */

#include "rsxnt.h"

int __close(int fd)
{
    EMXPROCESS *p = _rsxnt_get_process_ptr();
    int retv;

    if (fd >= N_FILES || fd < 0)
	return _rsxnt_errno(EBADF);
    if (p->file[fd].f_handle == INVALID_HANDLE_VALUE)
	return _rsxnt_errno(EBADF);

    if (p->file[fd].f_mode == HT_SOCKET)
    {
	if (!_rsxnt_socket_fop.close)
            retv = _rsxnt_errno (EBADF);
	else
            retv = (*_rsxnt_socket_fop.close) ((int) p->file[fd].f_handle);
    }
    else if (CloseHandle (p->file[fd].f_handle) == FALSE)
        retv = _rsxnt_get_last_errno();
    else
        retv = 0;

    p->file[fd].f_mode = 0;
    p->file[fd].f_handle = INVALID_HANDLE_VALUE;
    return retv;
}
