/*
 * LaTeD Version 1.1
 * (c) Gene Ressler 1993, 94, 97
 *   de8827@trotter.usma.edu
 *
 * LaTeD is a graphical editor for drawings in the LaTeX "picture" 
 * environment.  It runs under MSDOS or in a Windows DOS box.  The
 * distribution includes full sources, including LaTeX source for 
 * its documentation.
 *
 * No warranty of this software is expressed or implied by the author.
 *
 * Copy and use this program freely for any purpose except for sale
 * of the program (including the source code) itself.  That is, 
 * no one can copy this program for the purpose of providing it to 
 * another person in exchange for money or other compensation, even 
 * if this program is only part of the exchange.
 *
 * All copies of computer source code in this distribution, whether
 * copies in whole or in part, must have this notice attached.
 */

/* RESOURCE.H --- Resource compilation with cpp. */

#define array_size(A)   (sizeof A/sizeof A[0])

#define BeginDefMenu(Name) \
  extern MENU_REC Name[]; \
  MENU_ENTRY_REC Name##_entries[] = {

#define NoHotChar NO_HOT_CHAR
#define HotSpace  HOT_SPACE
#define DefMenuEntry(Text, HotPos, HotKey, Flags, Action) \
  { _W_, { Text, HotPos }, HotKey, Flags, Action },
#define activate_submenu	null_action_code
#define DefSubmenuEntry(Text, HotPos, Submenu, Flags) \
  { _W_, { Text, HotPos}, SUBMENU_MARK, \
  Flags|bit(meSUBMENU), { Submenu, activate_submenu } },


#define NullEnv                         NULL
#define Closure(Fun, Env)               {Env, Fun}
#define ActionClosure(Fun, Env)         Closure((ACTION_CODE)Fun, (ENV)Env)
#define PositionActionClosure(Fun, Env) Closure((POSITION_ACTION_CODE)Fun, (ENV)Env)
#define NameActionClosure(Fun, Env)     Closure((NAME_ACTION_CODE)Fun, (ENV)Env)
#define NullAction                      {NullEnv, null_action_code}
#define NullPositionAction              {NullEnv, null_position_action_code}
#define NullNameAction                  {NullEnv, null_name_action_code}

#define Ruled   bit(meRULED)
#define Enabled bit(meENABLED)
#define NoFlags 0
#define NoHotKey NO_HOT_KEY

#define EndDefMenu(Name, Width) \
  }; \
  MENU_REC Name[1] = {{ _W_, \
    Name##_entries, \
    array_size(Name##_entries), \
    Width, bit(mSAVE_UNDER) }};

#define MenuEntry(Name, Index)	(&Name##_entries[Index])

#define BeginDefPulldownBar(Name) \
  MENU_ENTRY_REC Name##_entries[] = {

#define DefPulldownEntry(Text, HotPos, Submenu) \
  { _W_, { Text, HotPos }, NO_HOT_KEY, \
  Enabled|bit(meSUBMENU)|bit(meHOT_HOT_CHAR)|bit(meACT_ON_PRESS), \
  { Submenu, activate_submenu } },

#define EndDefPulldownBar(Name) \
  }; \
  PULLDOWN_REC Name[1] = {{_W_, \
    Name##_entries, \
    array_size(Name##_entries), 0, bit(mBAR) }};

#define BeginDefText(Name) \
  char *Name##_lines[] = {

#define DefLine(Text) Text,

#define LeftJustify LEFT_TEXT
#define RightJustify RIGHT_TEXT
#define CenterJustify CENTER_TEXT

#define EndDefText(Name, Justify) \
  }; \
  TEXT_REC Name[1] = {{_W_, \
    Name##_lines, array_size(Name##_lines), Justify }};

/* Chiseled metal. */
#define DEFAULT_BUTTON_FG_COLOR	cBLACK
#define DEFAULT_BUTTON_BG_COLOR cLIGHTGRAY

#define DefBitmapButton(Name, Bitmap, HotKey, ShadowWidth, BorderWidth, Flags, Action) \
  BUTTON_REC Name[1] = {{ _W_, \
    Bitmap##_bits, Bitmap##_width, Bitmap##_height, \
    HotKey, ShadowWidth, BorderWidth, \
    DEFAULT_BUTTON_FG_COLOR, DEFAULT_BUTTON_BG_COLOR, \
    Flags|bit(bBITMAP), Action }};

#define MAX(X,Y)	((X) > (Y) ? (X) : (Y))

#define DefTextButton(Name, Text, HotChar, HotKey, Width, Height, ShadowWidth, BorderWidth, Flags, Action) \
  HOT_TEXT_REC Name##_button_text[1] = {{ Text, HotChar }}; \
  BUTTON_REC Name[1] = {{ _W_, \
    Name##_button_text, \
    MAX(8*(sizeof Text - 1) + 4, Width), \
    MAX(14, Height), \
    HotKey, ShadowWidth, BorderWidth, \
    DEFAULT_BUTTON_FG_COLOR, DEFAULT_BUTTON_BG_COLOR, \
    Flags, Action }};

/* Use same Enabled flag as for menus, else we have a problem. */
#if bENABLED != meENABLED
#error Bad assumption on ENABLED value.
#endif
#define Toggle  bit(bTOGGLE)
#define On      bit(bON)
#define Repeat  bit(bREPEAT)

#define SetBitmapButtonDesc(Name, Bitmap, HotKey, ShadowWidth, BorderWidth, Flags, Code, Env) \
  { (Name)->icon = Bitmap##_bits; \
    (Name)->width = Bitmap##_width; \
    (Name)->height = Bitmap##_height; \
    (Name)->hot_key = HotKey; \
    (Name)->status = (Flags)|bit(bBITMAP); \
    (Name)->shadow_width = (ShadowWidth); \
    (Name)->border_width = (BorderWidth); \
    (Name)->fg_color = DEFAULT_BUTTON_FG_COLOR; \
    (Name)->bg_color = DEFAULT_BUTTON_BG_COLOR; \
    (Name)->action.code = (Code); \
    (Name)->action.env = (Env); }

#if ebENABLED != meENABLED
#error Bad assumption on ENABLED value.
#endif

#define BeginDefEditBox(Name) \
  extern EDIT_BOX_REC Name[]; \
  KEY_NAME_ACTION_REC Name##_key_actions[] = { 
#define DefKeyAction(Key, Action) { Key, Action },
/* Cannot occur as regular key.  See key.h */
#define VALIDATOR_PSEUDOKEY 0x4500
#define DefValidator(Action) { VALIDATOR_PSEUDOKEY, Action },
#define EndDefEditBox(Name, Title, HotChar, BoxLen, BufLen, Flags) \
  { '\t', NameActionClosure(surrender_focus_action, Name) } }; \
  EDIT_BOX_REC Name[1] = {{ _W_, { Title, HotChar }, \
    BoxLen, BufLen, Name##_key_actions, array_size(Name##_key_actions), Flags }};
#define NoTitle NULL

#define DefScrollbar(Name, Title, HotChar, Len, Npos, NIncPos, NStepPos, InitPos, Flags, Action) \
  SCROLLBAR_REC Name[1] = {{ _W_, { Title, HotChar }, \
    Len, Npos, NIncPos, NStepPos, InitPos, Flags, Action }};

#define SetScrollbar(Name, Title, HotChar, Len, Npos, NIncPos, NStepPos, InitPos, Flags, Code, Env) \
  { (Name)->title.str = (Title); \
    (Name)->title.hot_char = (HotChar); \
    (Name)->length = (Len); \
    (Name)->n_pos = (Npos); \
    (Name)->n_inc_pos = (NIncPos); \
    (Name)->n_step_pos = (NStepPos); \
    (Name)->pos = (InitPos); \
    (Name)->status = (Flags); \
    (Name)->action.code = (Code); \
    (Name)->action.env = (Env); }

#if sbENABLED != meENABLED
#error Bad assumption on ENABLED value.
#endif
#define Vertical bit(sbVERTICAL)
#define OneOfTwo bit(sb1OF2)
#define Reverse bit(sbREVERSE)
#define Default DEFAULT
#define FullLength FULL_LENGTH

#define NoEntries NULL
#define NoWrap NO_WRAP
#define BeginDefTable(Name) \
  extern TABLE_REC Name[]; KEY_NAME_ACTION_REC Name##_key_actions[] = {
/* Uses same KeyAction def as edit boxes. */
#define EndDefTable(Name, Title, HotChar, Entries, NEntries, EntryLen, Wrap, NVisRows, NVisCols, Flags) \
  { '\t', NameActionClosure(surrender_focus_action, Name) } }; \
  TABLE_REC Name[1] = {{ _W_, { Title, HotChar }, \
    Entries, NEntries, EntryLen, Wrap, NVisRows, NVisCols, Flags, \
    Name##_key_actions, array_size(Name##_key_actions), Flags }};


#if tENABLED != meENABLED
#error Bad assumption on ENABLED value.
#endif

#if sVERTICAL != sbVERTICAL
#error Bad assumption on VERTICAL value.
#endif

#define Selector bit(bSELECTOR)

#define BeginDefSelector(Name, BorderWidth) \
  enum { Name##_BORDER_WIDTH = BorderWidth }; \
  BUTTON_REC Name##_buttons[] = {

#define DefBitmapSelectorButton(Name, Bitmap, HotKey, ShadowWidth, Flags, Action) \
  { _W_, Bitmap##_bits, Bitmap##_width, Bitmap##_height, \
    HotKey, ShadowWidth, Name##_BORDER_WIDTH, \
    DEFAULT_BUTTON_FG_COLOR, DEFAULT_BUTTON_BG_COLOR, \
    Flags|bit(bBITMAP), Action },

#define EndDefSelector(Name, Flags) \
  }; \
  SELECTOR_REC Name[1] = {{ _W_, \
    Name##_buttons, array_size(Name##_buttons), Flags }};

#define BeginDefColorSelector(Name, BorderWidth) \
  enum { Name##_BORDER_WIDTH = BorderWidth }; \
  BUTTON_REC Name##_buttons[] = {

#define DefColorSelectorButton(Name, Index, Color, Flags, ActionCode) \
  { _W_, color_bits, color_width, color_height, \
    NoHotKey, 2, Name##_BORDER_WIDTH, \
    Color, Color, \
    Flags|bit(bBITMAP)|Toggle|Selector, \
    { &Name##_buttons[Index], ActionCode } },

#define EndDefColorSelector(Name, Flags) \
  }; \
  SELECTOR_REC Name[1] = {{ _W_, \
    Name##_buttons, array_size(Name##_buttons), Flags }};

#define BeginDefDialog(Name) \
  DIALOG_ITEM_REC Name##_dialog_items[] = {

#define ButtonItem diBUTTON
#define CheckBoxItem diCHECKS
#define EditBoxItem diEDIT_BOX
#define ScrollbarItem diSCROLLBAR
#define RadioItem diRADIO
#define SelectorItem diSELECTOR
#define TableItem diTABLE
#define TextItem diTEXT

#define DefDialogItem(Type, Desc, X, Y) \
  { Type, (WINDOW)Desc, X, Y , bit(diENABLED) },

#define EndDefDialog(Name, Title, Flags) \
  }; \
  DIALOG_REC Name[1] = {{ _W_, \
    Title, Name##_dialog_items, \
    array_size(Name##_dialog_items), Flags }};

#if rENABLED != meENABLED
#error Bad assumption on ENABLED value.
#endif

#define BeginDefRadio(Name) \
  RADIO_ENTRY_REC Name##_radio_items[] = {

#define DefRadioItem(Text, HotChar) { _W_, { Text, HotChar} },

#define EndDefRadio(Name, Title, InitPos, Flags, Action) \
  }; \
  RADIO_REC Name[1] = {{ _W_, \
    Title, Name##_radio_items, array_size(Name##_radio_items), \
    InitPos, Flags, Action }};

#if hENABLED != meENABLED
#error Bad assumption on ENABLED value.
#endif

#define BeginDefChecks(Name) \
  CHECKS_ENTRY_REC Name##_checks_items[] = {

#define DefChecksItem(Text, HotChar) {_W_, { Text, HotChar } },

#define EndDefChecks(Name, Title, InitOn, Flags, Action) \
  }; \
  CHECKS_REC Name[1] = {{_W_, \
    Title, \
    Name##_checks_items, array_size(Name##_checks_items), \
    InitOn, Flags, Action }};
