unit VFOutput;
{$I option.pas}
interface
uses Dos, VFDcl, VFString, VFParm;

procedure OutputLig(stitle : string;
                    var FLig, FLigB : ptrLigRecord);
procedure OutputVPL(var fn : text);
procedure OutputTable(var fn : text);

implementation

procedure COMMENT(var fn : text);
begin
     writeln(fn,'(COMMENT)'#13#10'(COMMENT)'#13#10'(COMMENT)');
end; {Comment}

procedure Print8(var fn : text; ss : string);
begin
     if ss <> '' then writeln(fn,' ':8,'(',ss,')');
end; {Print8}

procedure PrintNoAuto(var fn : text; j,i : integer);
begin
     if (j >= i) then
     begin
         writeln(fn,' ':5,'(NOTAUTOADDCHAR (CHAR '+ConvChar(i)+'))');
     end
     else begin
         writeln(fn,' ':5,'(NOTAUTOADDCHAR (RANGE '
             +ConvChar(j)+' '++ConvChar(i)+'))')
     end;
end; {PrintNoAuto}

procedure OutputTable(var fn : text);
var i, j  : integer;
    ptrD  : ptrDiscardChar;
    ptrDD : ptrDVIRecord;
    ptrH  : ptrLigRecord;
    ptrV  : ptrVarRecord;
var VDayOf, VDay, VMonth, VYear : word;
var VHour, VMin, VSec, VSec100  : word;
    sDir   : DirStr;
    sNam   : NameStr;
    sExt   : ExtStr;
var sday, syear : string[4];
    s, ss : string;
    shelp : string[10];
    flf : boolean;
begin

     writeln(fn,'(COMMENT  This is the MAP Table generated from the file ',
              TableNameGlb,')');

     GetDate(VYear,VMonth,VDay,VDayOf);
     str(VYear:4,syear); str(VDay:2,sday);
     writeln(fn,'(COMMENT  (Date '+MonthName[VMonth]+sday+', '+syear
           +' ['+DayName[VDayOf]+']))');
     GetTime(VHour,VMin,VSec,VSec100);
     writeln(fn,'(COMMENT  (Time ',VHour:2,':',VMin:2,':',VSec:2,'))');
     {
     writeln(fn,'(VTITLE '+VTitleGlb+')');
     }

     COMMENT(fn);
     writeln(fn,' ':5,'(TBFDESIGNUNITS R ',
                    ConvReal(VParamGlb.FontDesignUnits));
     writeln(fn,' ':5,'(TBFDESIGNSIZE R ',
                    ConvReal(VParamGlb.FontDesignSize));
     COMMENT(fn);

     FileSplit(FontNameGlb,sDir,sNam,sExt);
     writeln(fn,' ':5,'(OUTPUT ',sNam);
     case FlOutChar of
     0 : ss:='ALLCHAR';
     1 : ss:= 'ALPHA';
     2 : ss:= 'ALPHANUM';
     3 : ss:= 'ALLCODE';
     else ss:='';
     end; {case}
     Print8(fn,ss);

     case FlOutByte of
     0 : ss:='DECIMAL';
     1 : ss:='OCTAL';
     2 : ss:='HEXADECIMAL';
     else ss:='';
     end; {case}
     Print8(fn,ss);
     writeln(fn,' ':5,')');

     COMMENT(fn);

     writeln(fn,' ':5,'(OPTIONS');
     case FlTraceLigGlb of
     3 : ss:='TRACE D 3';
     2 : ss:='TRACE';
     1 : ss:='TRACE D 1';
     0 : ss:='NOTRACE';
     else ss:='';
     end; {case}
     Print8(fn,ss);

     case FlIncludeGlb of
     4 : ss:='INCLUDECHAR (ALLCHAR)';
     3 : ss:='INCLUDECHAR (LIGTABLE)';
     2 : ss:='INCLUDECHAR (KRNDATA)';
     1 : ss:='INCLUDECHAR (LIGDATA)';
     0 : ss:='INCLUDECHAR (NOLIGTABLE)';
     else ss:='';
     end; {case}
     Print8(fn,ss);

     if FlNoNextCharGlb then Print8(fn,'INCLUDECHAR (NONEXTCHAR)')
                        else Print8(fn,'INCLUDECHAR (NEXTCHAR)');

     if FlagNullDVIGlb then Print8(fn,'PHANTOM');

     if FlLigTableGlb then Print8(fn,'LIGTABLE')
                      else Print8(fn,'NOLIGTABLE');

     if FlDiscIncludeGlb then Print8(fn,'NEWDISCARD')
                         else Print8(fn,'NONEWDISCARD');

     if FlScreen then Print8(fn,'SCREEN')
                 else Print8(fn,'NOSCREEN');

     case FlFontTFMDataGlb of
     1 : ss:='AUTOTFMMAPCHAR';
     2 : ss:='AUTOTFMCHAR';
     else ss:='';
     end; {case}
     if s <> '' then ss:=ss+' '+ConvInt(IndexTFMFontGlb);
     Print8(fn,ss);

     if FlFontAutoWidthGlb then ss:='AUTOTFMWIDTH'
                           else ss:='NOAUTOTFMWIDTH';
     Print8(fn,ss);

     writeln(fn,' ':5,' )');

     COMMENT(fn);

     ptrV:=ptrVariableGlb;
     if ptrV <> nil then
     begin
           COMMENT(fn);
           writeln(fn,' ':5,'(VARIABLE');
           while ptrV <> nil do
           begin
                case ptrV^.VType of
                VarNone : ;
                VarChar : Print8(fn,'CHARACTER '+ptrV^.VName+' '
                                  +ConvChar(ptrV^.cval));
                VarInt  : Print8(fn,'INTEGER '+ptrV^.VName+' D '
                                  +ConvDecLongInt(ptrV^.jval));
                VarReal : Print8(fn,'REAL '+ptrV^.VName+' R '
                                  +ConvRealTrue(ptrV^.rval));
                VarStr : Print8(fn,'STRING '+ptrV^.VName+' '
                                  +ptrV^.psval^);
                else Print8(fn,'UNKNOWN-TYPE');
                end; {case}
                ptrV:=ptrV^.ptrNext;
           end; {while}
           writeln(fn,' ':5,')');
     end;

     COMMENT(fn);

     for i:=0 to MaxFontNumber do
     if FontsParm^[i].FlagFontUsed then
     with FontsParm^[i] do
     begin

         if not DefTraceLig then FlTraceLig:=FlTraceLigGlb;
         if not DefInclude  then FlInclude :=FlIncludeGlb;
         if not DefLigTable then FlLigTable:=FlLigTableGlb;
         if not DefDiscIncl then FlDiscIncl:=FlDiscIncludeGlb;

         writeln(fn,' ':5,'(MAPFONT D '+ConvInt(i));

         if FlCheckSum then
            Print8(fn,'CHECKSUM D '+ConvDecLongInt(CheckSum));

         if FlFontDSize then
            Print8(fn,'DESIGNSIZE R '+ConvRealTrue(FontDSize));

         if FlFontDUnits then
            Print8(fn,'DESIGNUNITS R '+ConvRealTrue(FontDUnits));

         case MapFontMode of
         FModeNone    : ss:='';
         FModeFull    : ss:='FULL';
         FMode7to8    : ss:='7TO8';
         FMode8to7    : ss:='8TO7';
         FModeHbit    : ss:='8TO8';
         FModeLBit    : ss:='7TO7';
         FModeJWNCyr  : ss:='JWNCYR';
         FModeAltGost : ss:='CYRTUG';
         else ss:='';
         end; {case}
         Print8(fn,ss);

         case FlTraceLig of
         3 : ss:='TRACE D 3';
         2 : ss:='TRACE';
         1 : ss:='TRACE D 1';
         0 : ss:='NOTRACE';
         else ss:='';
         end; {case}
         Print8(fn,ss);

         if (FontName <> '') and (FontName <> ' ')
            then Print8(fn,'FONTNAME '+FontName);

         if (FontTFMName <> '') and (FontTFMName <> ' ')
            then Print8(fn,'TFMINPUT '+FontTFMName);

         if DefFontAutoWidth then
         begin
              if FlFontAutoWidth
                 then ss:='AUTOTFMWIDTH'
                 else ss:='NOAUTOTFMWIDTH';
              Print8(fn,ss);
         end;

         case FlFontTFMData of
         1 : ss:='AUTOTFMMAPCHAR';
         2 : ss:='AUTOTFMCHAR';
         else ss:='';
         end; {case}
         if s <> '' then ss:=ss+' '+ConvInt(IndexTFMFont);
         Print8(fn,ss);

         if FlFontAt then Print8(fn,'FONTAT R '+ConvRealTrue(FontAt));

         if (FontArea <> '') and (FontArea <> ' ')
            then Print8(fn,'FONTAREA '+FontArea);

         if DefNullDvi then
         begin
              if FlagNullDVI then Print8(fn,'PHANTOM')
                             else Print8(fn,'NOPHANTOM');
         end;

         case FlInclude of
         4 : ss:='INCLUDECHAR (ALLCHAR)';
         3 : ss:='INCLUDECHAR (LIGTABLE)';
         2 : ss:='INCLUDECHAR (KRNDATA)';
         1 : ss:='INCLUDECHAR (LIGDATA)';
         0 : ss:='INCLUDECHAR (NOLIGTABLE)';
         else ss:='';
         end; {case}
         Print8(fn,ss);

         if FlNoNextChar then Print8(fn,'INCLUDECHAR (NONEXTCHAR)')
                         else Print8(fn,'INCLUDECHAR (NEXTCHAR)');

         if FlLigTable then Print8(fn,'LIGTABLE')
                       else Print8(fn,'NOLIGTABLE');

         if FlDiscIncl then Print8(fn,'NEWDISCARD')
                       else Print8(fn,'NONEWDISCARD');

         writeln(fn,' ':5,')');

     end; {for i}

     COMMENT(fn);

     writeln(fn,' ':5,'(BOUNDARYCHAR '+ConvChar(BoundCharGlb)+')');
     writeln(fn,' ':5,'(LIGUNITS R '
                  +ConvRealTrue(VParamGlb.FontDesignUnits)+')');
     writeln(fn,' ':5,'(LIGDESIGNSIZE R '
                  +ConvRealTrue(VParamGlb.FontDesignSize)+')');

     if ptrLigTable <> nil then
     begin
          COMMENT(fn);
          writeln(fn,' ':5,'(LIGTABLE');
          ptrH:=ptrLigTable;
          while ptrH <> nil do
          with ptrH^ do
          begin
                 case TTLig of
                 TLabel : begin
                    s:='(LABEL '+ConvChar(LigChar)+')';
                 end;
                 TLabelBoundary : begin
                    s:='(LABEL BOUNDARYCHAR)';
                 end;
                 TKern : begin
                    s:='(KRN '+ConvChar(KernChar)
                                +' R '+ConvRealTrue(KernValue)+')';
                 end;
                 TStop : begin
                    s:='(STOP)';
                 end;
                 TSkip : begin
                    s:='(SKIP D '+ConvByte(SkipNum)+')';
                 end;
                 TLig, TSLig, TSLigH, TLigS, TLigSH,
                 TSLigS, TSLigSH, TSLigSHH : begin
                    case TTLig of
                    TLig : shelp:='LIG';
                    TSLig : shelp:='/LIG';
                    TSLigH : shelp:='/LIG>';
                    TLigS : shelp:='LIG/';
                    TLigSH : shelp:='LIG/>';
                    TSLigS : shelp:='/LIG/';
                    TSLigSH : shelp:='/LIG/>';
                    TSLigSHH : shelp:='/LIG/>>';
                    else shelp:='*LIG*';
                    end; {case}
                    s:='('+shelp+' '+ConvChar(NextChar)
                               +' '+ConvChar(InsChar)+')';
                 end;
                 else begin
                         s:='(??? UNKNOWN TYPE '+ConvInt(ord(TLig))+')';
                      end;
                 end; {case}
                 writeln(fn,' ':10,s);
                 ptrH:=ptrH^.ptrNext;
          end; {while}
          writeln(fn,' ':5,')');
     end;

     COMMENT(fn);

     for i:=0 to 255 do
     if FlagSaveUnknown or (CharDataGlb^[i].marked <> CharNotUsed) then
     begin
          writeln(fn,' ':5,'(CHARACTER '+ConvChar(i));
          with CharDataGlb^[i] do
          begin
               if FlPhantom then ss:='PHANTOM'
                            else ss:='NOPHANTOM';
               Print8(fn,ss);

               case marked of
               CharNotUsed : Print8(fn,'UNKNOWN');
               CharUsed    : Print8(fn,'SELECTFONT D '+ConvByte(mapfont)+') '
                                       +'(SETCHAR '+ConvChar(mapchar));
               CharDVI     : begin
{...........................................................................}
                    writeln(fn,' ':8,'(DVI ');
                    ptrDD:=ptrDVI; flf:=false;

                    while ptrDD <> nil do
                    begin

                        with ptrDD^ do
                        case TDVI of
                        DVIFont : begin
                           writeln(fn,' ':12,'(SELECTFONT D '+ConvInt(nfont)+')');
                           flf:=true;
                           end;
                        DVIChar : begin
                           if not flf
                             then writeln(fn,' ':12,'(SELECTFONT D 0)');
                           writeln(fn,' ':12,'(SETCHAR '+ConvChar(nchar)+')');
                           flf:=true;
                           end;
                        DVIRule :
                           writeln(fn,' ':12,'(SETRULE R '+ConvRealTrue(height)+' R '+ConvRealTrue(width)+')');
                        DVIRight :
                           writeln(fn,' ':12,'(MOVERIGHT R '+ConvReal(dist)+')');
                        DVILeft :
                           writeln(fn,' ':12,'(MOVELEFT R '+ConvReal(dist)+')');
                        DVIUp :
                           writeln(fn,' ':12,'(MOVEUP R '+ConvReal(dist)+')');
                        DVIDown :
                           writeln(fn,' ':12,'(MOVEDOWN R '+ConvReal(dist)+')');
                        DVIPush :
                           writeln(fn,' ':12,'(PUSH)');
                        DVIPop :
                           writeln(fn,' ':12,'(POP)');
                        DVISpec :
                           writeln(fn,' ':12,'(SPECIAL '+spec+')');
                        DVISpecHex :
                           writeln(fn,' ':12,'(SPECIALHEX '+spec+')');
                        end; {case, with}

                        ptrDD:=ptrDD^.ptrNext;

                    end; {while}

                    writeln(fn,' ':8,')');

{...........................................................................}
                             end;
               CharDiscard : Print8(fn,'DISCARD');
               end; {case}

               if marked in [CharUsed, CharDVI] then
               begin

                    if FlTFMData then
                    begin
                        Print8(fn,'TFMFONT D '+Convbyte(sizefont));
                        Print8(fn,'TFMCHAR '+ConvChar(sizechar));
                    end
                    else if DefFlTFMData and (not FlTFMData) then
                    begin
                        Print8(fn,'NOTFMDATA');
                    end;

                    if DefPKWidth then
                       Print8(fn,'PKWIDTH R '+ConvRealTrue(PKWidth));

                    if FlAutoWidth then ss:='AUTOTFMWIDTH'
                                   else ss:='NOAUTOTFMWIDTH';
                    Print8(fn,ss);

                    if FlCharWD then Print8(fn,'CHARWD R '+ConvRealTrue(CharWD));
                    if FlCharHT then Print8(fn,'CHARHT R '+ConvRealTrue(CharHT));
                    if FlCharDP then Print8(fn,'CHARDP R '+ConvRealTrue(CharDP));
                    if FlCharIC then Print8(fn,'CHARIC R '+ConvRealTrue(CharIC));

                    if FlNextLarger
                       then Print8(fn,'NEXTLARGER '+ConvChar(NextLarger));

                    if FlVarChar then
                    begin
                         writeln(fn,' ':8,'(VARCHAR');
                         if FlTop then writeln(fn,' ':8,'   (TOP '+ConvChar(TOP)+')');
                         if FlMid then writeln(fn,' ':8,'   (MID '+ConvChar(MID)+')');
                         if FlBot then writeln(fn,' ':8,'   (BOT '+ConvChar(BOT)+')');
                         if FlRep then writeln(fn,' ':8,'   (REP '+ConvChar(REP)+')');
                         writeln(fn,' ':8,')');
                    end;

               end;
          end;
          writeln(fn,' ':5,')');
     end;

     if FlagSaveDiscard and (ptrDiscCharGlb <> nil) then
     begin

        COMMENT(fn);

        ptrD:=ptrDiscCharGlb;
        while ptrD <> nil do
        begin
          with ptrD^ do
          begin
             writeln(fn,' ':5,'(DISCARDCHAR (SELECTFONT D '+ConvByte(fontnum)
                        +') (SETCHAR '+ConvChar(charnum)+'))');
          end;
          ptrD:=ptrD^.ptrNext;
        end;

     end;


     COMMENT(fn);
     flf:=false; j:=0;
     for i:=0 to 255 do
     begin
          if flf and (CharDataGlb^[i].marked <> CharDiscard)
          then begin
               PrintNoAuto(fn,j,i-1);
               flf:=false;
          end;
          if (not flf) and (CharDataGlb^[i].marked = CharDiscard)
          then begin
               flf:=true; j:=i;
          end;
     end;
     if flf then PrintNoAuto(fn,j,255);

end; {OutputTable}


procedure OutputLig(stitle : string;
                    var FLig, FLigB : ptrLigRecord);
var s, sh, sii : string;
    shelp : string;
    ptrLig : ptrLigRecord;
    jj : integer;
    flLig  : byte;
begin
     {------- Create LIGTABLE ------}
     if (FLig <> nil) or (FLigB <> nil) then
     begin
         ErrorLog(' ');
         ErrorLog('### LIGTABLE : '+stitle);
         flLig:=0; ptrLig:=nil; jj:=0;

         while (fllig < 3) do
         begin
             if ptrLig <> nil then
             with ptrLig^ do
             begin

                 jj:=jj+1;

                 case marked of
                 LigNotUsed   : sh:='.....';
                 LigNotUsedM  : sh:='..M..';
                 LigDiscard   : sh:='-----';
                 LigAdded     : sh:='+++++';
                 LigUsed      : sh:='     ';
                 LigUsedBound : sh:='Bound';
                 else           sh:='(???)';
                 end; {case}

                 case TTLig of
                 TLabel : begin
                    s:='(LABEL '+ConvChar(LigChar)+')';
                 end;
                 TLabelBoundary : begin
                    s:='(LABEL BOUNDARYCHAR)';
                 end;
                 TKern : begin
                    s:='(KRN '+ConvChar(KernChar)
                                +' R '+ConvRealTrue(KernValue)+')';
                 end;
                 TStop : begin
                    s:='(STOP)';
                 end;
                 TSkip : begin
                    s:='(SKIP D '+ConvByte(SkipNum)+')';
                 end;
                 TLig, TSLig, TSLigH, TLigS, TLigSH,
                 TSLigS, TSLigSH, TSLigSHH : begin
                    case TTLig of
                    TLig : shelp:='LIG';
                    TSLig : shelp:='/LIG';
                    TSLigH : shelp:='/LIG>';
                    TLigS : shelp:='LIG/';
                    TLigSH : shelp:='LIG/>';
                    TSLigS : shelp:='/LIG/';
                    TSLigSH : shelp:='/LIG/>';
                    TSLigSHH : shelp:='/LIG/>>';
                    else shelp:='*LIG*';
                    end; {case}
                    s:='('+shelp+' '+ConvChar(NextChar)
                               +' '+ConvChar(InsChar)+')';
                 end;
                 else begin
                         s:='(??? UNKNOWN TYPE '+ConvInt(ord(TLig))+')';
                      end;
                 end; {case}

                 str(jj:4,sii);
                 ErrorLog(sii+'   '+sh+'   '+s);

                 ptrLig:=ptrlig^.ptrNext;
             end
             else begin
                  jj:=0;
                  case flLig of
                  0 : begin
                         flLig:=1;
                         if (FLigB <> nil) then
                         begin
                              ErrorLog('    BOUNDARYCHAR LIGTABLE');
                              ptrLig:=FLigB;
                         end
                         else ptrLig:=nil;
                      end;
                  1 : begin
                         flLig:=2;
                         if FLig <> nil then
                         begin
                               ErrorLog('    MAIN LIGTABLE');
                               ptrLig:=FLig;
                         end
                         else ptrLig:=nil;
                      end;
                  else begin
                         flLig:=3; ptrLig:=nil;
                      end;
                  end; {case flLig}
             end; {ptrLig = nil}
         end; {while}

         ErrorLog('  ');
     end; {LigTable}

end;   {OutputLig}


procedure OutputVPL(var fn : text);
{---------------------------}
{  This program converts    }
{  the coupled data into    }
{  ASCII *.VPL font         }
{---------------------------}
const MaxPushStack = 20;
var   StackX, StackY : array [1..MaxPushStack] of float;
      NStack : integer;
var i : integer;
var ptrLig : ptrLigRecord;
    ptrDD  : ptrDVIRecord;
    flLig  : byte;
    shelp : string;
var rheight, rdepth, rxpos, rypos : float;
var VDayOf, VDay, VMonth, VYear : word;
var VHour, VMin, VSec, VSec100 : word;
var sday, syear : string[4];
var SDir : DirStr;
    sNam : NameStr;
    sExt : ExtStr;
var flf : boolean;
    FlCorr : boolean;
begin

     {----- Create VTITLE and other header parameters ---------------------}
     {--- Note : Header <num> <4-byte num> is not supported -------}
     {--- Note : CheckSum, SevenBitSafeFlag - are not specified ---}

     if VTitleGlb <> '' then
     begin
        writeln(fn,'(VTITLE ',VTitleGlb,' ');
        GetDate(VYear,VMonth,VDay,VDayOf);
        str(VYear:4,syear); str(VDay:2,sday);
        writeln(fn,'   ('+MonthName[VMonth]+sday+', '+syear
              +' ['+DayName[VDayOf]+'])');
        {
        GetTime(VHour,VMin,VSec,VSec100);
        writeln(fn,'   (Time ',VHour:2,':',VMin:2,':',VSec:2,') ');
        }
        writeln(fn,'   )');
     end;

     with VParamGlb do
     begin
        if FontFamily <> '' then
           writeln(fn,'(FAMILY ',FontFamily,')');
        if FontCoding <> '' then
           writeln(fn,'(CODINGSCHEME ',FontCoding,')');
        if FlCheckSumGlb then
           writeln(fn,'(CHECKSUM O ',ConvOctLongInt(FontCheckSum),')');

        if FontFace < 0 then
        begin
           ErrorLog('*** Warning : Font Face < 0 : '+ConvInt(FontFace));
           ErrorLog('              Font Face is set to 0');
           writeln(fn,'(FACE O 0)');
           FontFace:=0;
        end
        else
        if FontFace > 17 then
        begin
           writeln(fn,'(FACE O '+ConvOctByte(FontFace)+')');
        end
        else begin
          writeln(fn,'(FACE F ',FaceName[FontFace],')');
        end;

        if FontDesignSize < 1.0 then
        begin
           ErrorLog('*** Warning : DESIGNSIZE < 1.0 : '
                                        +ConvReal(FontDesignSize));
           ErrorLog('              DESIGNSIZE is set to 1.0');
           FontDesignSize:=1.0;
        end;
        if FontDesignSize >= 2048.0 then
        begin
           ErrorLog('*** Warning : DESIGNSIZE >= 2048.0 : '
                                        +ConvReal(FontDesignSize));
           ErrorLog('              DESIGNSIZE is set to 2047.99');
           FontDesignSize:=2047.99;
        end;
        writeln(fn,'(DESIGNSIZE R ',ConvRealTrue(FontDesignSize),')');

        if FontDesignUnits < 0.0 then
        begin
           ErrorLog('*** Warning : DESIGNUNITS <= 0.0 : '
                                        +ConvReal(FontDesignUnits));
           ErrorLog('              DESIGNUNITS is set to 1.0');
           FontDesignUnits:=1.0;
        end;
        writeln(fn,'(DESIGNUNITS R ',ConvRealTrue(FontDesignUnits),')');

     end;

     {------ Create FontDimen --------------------------------}
     {--- Note : PARAMETER <num> <real> - is not supported ---}
     if FlFontDimen then
     with FontDimenGlb do
     begin
         writeln(fn,'(FONTDIMEN');
         writeln(fn,'   (SLANT R ',ConvRealTrue(Slant),')');
         writeln(fn,'   (SPACE R ',ConvRealTrue(Space),')');
         writeln(fn,'   (STRETCH R ',ConvRealTrue(Stretch),')');
         writeln(fn,'   (SHRINK R ',ConvRealTrue(Shrink),')');
         writeln(fn,'   (XHEIGHT R ',ConvRealTrue(XHeight),')');
         writeln(fn,'   (QUAD R ',ConvRealTrue(Quad),')');
         writeln(fn,'   (EXTRASPACE R ',ConvRealTrue(ExtraSpace),')');
         if Num1 <> 0.0 then
            writeln(fn,'   (DEFAULTRULETHICKNESS R ',ConvRealTrue(Num1),')');
         if Num2 <> 0.0 then
            writeln(fn,'   (BIGOPSPACING1 R ',ConvRealTrue(Num2),')');
         if Num3 <> 0.0 then
            writeln(fn,'   (BIGOPSPACING2 R ',ConvRealTrue(Num3),')');
         if Denom1 <> 0.0 then
            writeln(fn,'   (BIGOPSPACING3 R ',ConvRealTrue(Denom1),')');
         if Denom2 <> 0.0 then
            writeln(fn,'   (BIGOPSPACING4 R ',ConvRealTrue(Denom2),')');
         if Sup1 <> 0.0 then
            writeln(fn,'   (BIGOPSPACING5 R ',ConvRealTrue(Sup1),')');
         if Sup2 <> 0.0 then
            writeln(fn,'   (SUP2 R ',ConvRealTrue(Sup2),')');
         if Sup3 <> 0.0 then
            writeln(fn,'   (SUP3 R ',ConvRealTrue(Sup3),')');
         if Sub1 <> 0.0 then
            writeln(fn,'   (SUB1 R ',ConvRealTrue(Sub1),')');
         if Sub2 <> 0.0 then
            writeln(fn,'   (SUB2 R ',ConvRealTrue(Sub2),')');
         if SubDrop <> 0.0 then
            writeln(fn,'   (SUBDROP R ',ConvRealTrue(SubDrop),')');
         if SupDrop <> 0.0 then
            writeln(fn,'   (SUPDROP R ',ConvRealTrue(SupDrop),')');
         if Delim1 <> 0.0 then
            writeln(fn,'   (DELIM1 R ',ConvRealTrue(Delim1),')');
         if Delim2 <> 0.0 then
            writeln(fn,'   (DELIM2 R ',ConvRealTrue(Delim2),')');
         if AxisHeight <> 0.0 then
            writeln(fn,'   (AXISHEIGHT R ',ConvRealTrue(AxisHeight),')');
         writeln(fn,'   )');
     end;

     if FlBoundCharGlb then
        writeln(fn,'(BOUNDARYCHAR ',ConvChar(BoundCharGlb),')');

     {--- Create MAPFONT records ---}
     for i:=0 to MaxFontNumber do
     if FontsParm^[i].FlagFontUsed then
     with FontsParm^[i] do
     if FlagFontInclude then
     begin
         FileSplit(FontName,sDir,sNam,sExt);
         writeln(fn,'(MAPFONT D ',i);
         writeln(fn,'   (FONTNAME ',sNam,')');
         if FontArea <> '' then
         writeln(fn,'   (FONTAREA ',FontArea,')');
         if FlFontAt then
            writeln(fn,'   (FONTAT R ',ConvRealTrue(FontAt),')');
         writeln(fn,'   (FONTCHECKSUM O ',ConvOctLongInt(CheckSum),')');
         writeln(fn,'   (FONTDSIZE R ',ConvRealTrue(FontDSize),')');
         writeln(fn,'   )');
     end; {for i}

     {------- Create LIGTABLE ------}
     if (ptrLigMain <> nil) or (ptrLigBound <> nil) or (ptrLigTable <> nil)
     then begin
         writeln(fn,'(LIGTABLE');
         flLig:=0; ptrLig:=nil;

         while (fllig <= 3) do
         begin
             if ptrLig <> nil then
             with ptrLig^ do
             begin
                 case TTLig of
                 TLabel : begin
                    writeln(fn,'   (LABEL '+ConvChar(LigChar)+')');
                 end;
                 TLabelBoundary : begin
                    writeln(fn,'   (LABEL BOUNDARYCHAR)');
                    ErrorLog('*** Internal Error : LABEL BOUNDARYCHAR appears');
                 end;
                 TKern : begin
                    writeln(fn,'   (KRN '+ConvChar(KernChar)
                                +' R '+ConvRealTrue(KernValue)+')');
                 end;
                 TStop : begin
                    writeln(fn,'   (STOP)');
                 end;
                 TSkip : begin
                    writeln(fn,'   (SKIP D '+ConvByte(SkipNum)+')');
                 end;
                 TLig, TSLig, TSLigH, TLigS, TLigSH,
                 TSLigS, TSLigSH, TSLigSHH : begin
                    case TTLig of
                    TLig : shelp:='LIG';
                    TSLig : shelp:='/LIG';
                    TSLigH : shelp:='/LIG>';
                    TLigS : shelp:='LIG/';
                    TLigSH : shelp:='LIG/>';
                    TSLigS : shelp:='/LIG/';
                    TSLigSH : shelp:='/LIG/>';
                    TSLigSHH : shelp:='/LIG/>>';
                    else shelp:='*LIG*';
                    end; {case}
                    writeln(fn,'   ('+shelp+' '+ConvChar(NextChar)
                               +' '+ConvChar(InsChar)+')');
                 end;
                 else begin
                         ErrorLog('*** Internal Error : unknown TLIG type : '
                                        +ConvInt(ord(TLig)));
                         halt;
                      end;
                 end; {case}
                 ptrLig:=ptrlig^.ptrNext;
             end
             else begin
                  case flLig of
                  0 : begin
                         flLig:=1;
                         if (ptrLigBound <> nil) then
                         begin
                              writeln(fn,'      (LABEL BOUNDARYCHAR)');
                              ptrLig:=ptrLigBound;
                         end
                         else ptrLig:=nil;
                      end;
                  1 : begin
                         if (ptrLigBound <> nil) then
                         begin
                              writeln(fn,'      (STOP) (COMMENT (LABEL BOUNDARYCHAR))');
                         end;
                         flLig:=2; ptrLig:=ptrLigMain;
                      end;
                  2 : begin
                         flLig:=3; ptrLig:=ptrLigTable;
                      end;
                  else begin
                         flLig:=4; ptrLig:=nil;
                      end;
                  end; {case flLig}
             end; {ptrLig = nil}
         end; {while}

         writeln(fn,'   )');
     end; {LigTable}

     {------- Create CharList ------}
     for i:=0 to 255 do
     if CharDataGlb^[i].marked in [CharUsed, CharDVI] then
     with CharDataGlb^[i] do
     begin

        writeln(fn,'(CHARACTER '+ConvChar(i));

        {--- calculate char size ---}
        if marked = CharDVI then
        begin
             rheight:=0.0; rdepth:=0.0;
             rxpos:=0.0; rypos:=0.0;

             NStack:=0;
             ptrDD:=CharDataGlb^[i].ptrDVI;

             while ptrDD <> nil do
             begin
                with ptrDD^ do
                case TDVI of
                DVIFont : ;
                DVIChar : begin
                            rxpos:=rxpos + cwidth;
                            if (rypos + cheight) > rheight
                               then rheight:=(rypos + cheight);
                            if (rypos - cdepth) < (-rdepth)
                               then rdepth:=(cdepth-rypos);
                    end;
                DVIRule : begin
                            rxpos:=rxpos + width;
                            if (rypos + height) > rheight
                               then rheight:=(rypos + height);
                    end;
                DVIRight : rxpos:=rxpos+dist;
                DVILeft :  rxpos:=rxpos-dist;
                DVIUp :    begin
                                rypos:=rypos+dist;
                                if rheight < rypos then rheight:=rypos;
                                if (-rdepth) > rypos then rdepth:=-rypos;
                     end;
                DVIDown :  begin
                                rypos:=rypos-dist;
                                if rheight < rypos then rheight:=rypos;
                                if (-rdepth) > rypos then rdepth:=-rypos;
                     end;
                DVIPush :  if NStack < MaxPushStack then
                           begin
                                NStack:=NStack+1;
                                StackX[NStack]:=rxpos;
                                StackY[NStack]:=rypos;
                           end
                           else begin
                                ErrorLog('*** Internal Error : Push/Pop DVI Stack is exhausted');
                           end;
                DVIPop :   if NStack > 0 then
                           begin
                                NStack:=NStack+1;
                                rxpos:=StackX[NStack];
                                rypos:=StackY[NStack];
                                NStack:=NStack-1;
                           end
                           else begin
                                ErrorLog('*** Internal Error : Push/Pop DVI Stack error');
                           end;
                DVISpec :  ;
                DVISpecHex : ;
                end; {case, with}

                ptrDD:=ptrDD^.ptrNext;
             end; {while}

             if (not FlTFMData) and (not DefMapFont) and (not DefMapChar)
             then begin
                  if not FlCharWD then CharWD:=rxpos;
                  if not FlCharHT then CharHT:=rdepth;
                  if not FlCharDP then CharDP:=rdepth;
             end;

             if not DefPKWidth then PKWidth:=rxpos;

        end; {--- auto size calculation ---}

        if CharWD <> 0.0 then
           writeln(fn,'   (CHARWD R ',ConvRealTrue(CharWD),')');
        if CharHT <> 0.0 then
           writeln(fn,'   (CHARHT R ',ConvRealTrue(CharHT),')');
        if CharDP <> 0.0 then
           writeln(fn,'   (CHARDP R ',ConvRealTrue(CharDP),')');
        if CharIC <> 0.0 then
           writeln(fn,'   (CHARIC R ',ConvRealTrue(CharIC),')');

        case FlAddParm of
        0 : ;
        1 : writeln(fn,'   (NEXTLARGER ',ConvChar(NextLarger),')');
        2 : writeln(fn,'   (VARCHAR (TOP ',ConvChar(Top),
                                   ')(MID ',ConvChar(Mid),
                                   ')(BOT ',ConvChar(Bot),'))');
        3 : writeln(fn,'   (VARCHAR (TOP ',ConvChar(Top),
                                   ')(MID ',ConvChar(Mid),
                                   ')(BOT ',ConvChar(Bot),
                                   ')(REP ',ConvChar(Rep),'))');
        else begin
           ErrorLog('*** Warning : Character '+ConvInt(i)
                     +' - combination NEXTLARGER/VARCHAR is illegal ');
           ErrorLog('              NEXTLARGER/VARCHAR are ignored both');
        end;
        end; {case}

        if DefPKWidth
           then FlCorr:=true
           else FlCorr:=FlAutoWidth and (FlCharWD or FlTFMData);

        if FlPhantom then
        begin
             writeln(fn,'   (MAP (MOVERIGHT R '+ConvRealTrue(CharWD)+'))');
        end
        else
        if marked = CharUsed then
        begin
           if FlCorr then
           begin
                writeln(fn,'   (MAP ');
                writeln(fn,'        (PUSH)(MOVERIGHT R '
                           +ConvRealTrue(0.5*(CharWD-PKWidth))+')');
                writeln(fn,'        (SELECTFONT D ',CharDataGlb^[i].mapfont,
                              ')(SETCHAR ',ConvChar(CharDataGlb^[i].mapchar),')');
                writeln(fn,'        (POP)(MOVERIGHT R '
                           +ConvRealTrue(CharWD-PKWidth)+')');
                writeln(fn,'   )');
           end
           else begin
                writeln(fn,'   (MAP (SELECTFONT D ',CharDataGlb^[i].mapfont,
                              ')(SETCHAR ',ConvChar(CharDataGlb^[i].mapchar),'))');
           end
        end
        else begin {CharDVI}
           writeln(fn,'   (MAP ');

           if FlCorr then
           begin
                writeln(fn,'        (PUSH)(MOVERIGHT R '
                           +ConvRealTrue(0.5*(CharWD-PKWidth))+')');
           end;

           ptrDD:=CharDataGlb^[i].ptrDVI;
           flf:=false;

           while ptrDD <> nil do
           begin
                with ptrDD^ do
                case TDVI of
                DVIFont : begin
                        writeln(fn,'      (SELECTFONT D '+ConvInt(nfont)+')');
                        flf:=true;
                end;
                DVIChar : begin
                        if not flf then writeln(fn,'      (SELECTFONT D 0)');
                        writeln(fn,'      (SETCHAR '+ConvChar(nchar)+')');
                        flf:=true;
                end;
                DVIRule :
                        writeln(fn,'      (SETRULE R '+ConvRealTrue(height)+' R '+ConvRealTrue(width)+')');
                DVIRight :
                        writeln(fn,'      (MOVERIGHT R '+ConvRealTrue(dist)+')');
                DVILeft :
                        writeln(fn,'      (MOVELEFT R'+ConvRealTrue(dist)+')');
                DVIUp :
                        writeln(fn,'      (MOVEUP R '+ConvRealTrue(dist)+')');
                DVIDown :
                        writeln(fn,'      (MOVEDOWN R '+ConvRealTrue(dist)+')');
                DVIPush :
                        writeln(fn,'      (PUSH)');
                DVIPop :
                        writeln(fn,'      (POP)');
                DVISpec :
                        writeln(fn,'      (SPECIAL '+spec+')');
                DVISpecHex :
                        writeln(fn,'      (SPECIALHEX '+spec+')');
                end; {case, with}

                ptrDD:=ptrDD^.ptrNext;
           end; {while}

           if FlCorr then
           begin
                writeln(fn,'        (POP)(MOVERIGHT R '
                           +ConvRealTrue(CharWD-PKWidth)+')');
           end;
           writeln(fn,'      )');
        end; {--- chardvi ---}

        writeln(fn,'   )');

     end; {for i}

end; {OutputVPL}

end.
