/*
 * Decompiled with CFR 0.152.
 */
package nts.noad;

import nts.base.Dimen;
import nts.io.CntxLog;
import nts.io.Log;
import nts.noad.Converter;
import nts.noad.Egg;
import nts.noad.Field;
import nts.noad.Noad;
import nts.noad.Operator;
import nts.noad.StSimpleNodeEgg;
import nts.noad.WordPartNoad;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.IntVKernNode;
import nts.node.MathWordBuilder;
import nts.node.Node;
import nts.node.NodeList;
import nts.node.VBoxNode;
import nts.node.VShiftNode;

public class OpNoad
extends WordPartNoad {
    public static final byte SIDE_LIMITS = 0;
    public static final byte USUAL_LIMITS = 1;
    public static final byte DEFAULT_LIMITS = 2;
    private final byte limits;

    protected String getDesc() {
        return "mathop";
    }

    public boolean acceptsLimits() {
        return true;
    }

    public boolean canPrecedeBin() {
        return false;
    }

    protected byte spacingType() {
        return 1;
    }

    public Noad withLimits(byte limits) {
        return new OpNoad(this.nucleus, limits);
    }

    public void addOn(Log log, CntxLog cntx) {
        log.addEsc(this.getDesc());
        switch (this.limits) {
            case 0: {
                log.addEsc("nolimits");
                break;
            }
            case 1: {
                log.addEsc("limits");
                break;
            }
        }
        this.nucleus.addOn(log, cntx, '.');
    }

    protected boolean usingLimits(Converter conv, boolean display) {
        switch (this.limits) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return display;
    }

    public boolean isJustChar() {
        return false;
    }

    public Egg convert(Converter conv) {
        boolean display = conv.getStyle() == 0;
        return this.makeEgg(this.nucleus.makeOperator(conv, display), conv, display);
    }

    public Egg wordFinishingEgg(MathWordBuilder word, Converter conv) {
        if (word.lastHasCollapsed()) {
            return null;
        }
        boolean display = conv.getStyle() == 0;
        return this.makeEgg(this.nucleus.takeLastOperator(word, conv, display), conv, display);
    }

    private Egg makeEgg(Operator oper, Converter conv, boolean display) {
        return this.usingLimits(conv, display) ? new StSimpleNodeEgg(VBoxNode.packedOf(oper.getNodeToBeLimited()), this.spacingType()) : oper.getEggToBeScripted(this.spacingType());
    }

    public Egg convertWithScripts(Converter conv, Field sup, Field sub) {
        boolean display;
        boolean bl = display = conv.getStyle() == 0;
        if (!this.usingLimits(conv, display)) {
            return super.convertWithScripts(conv, sup, sub);
        }
        return this.makeEggWithScripts(this.nucleus.makeOperator(conv, display), conv, sup, sub);
    }

    public Egg wordFinishingEggWithScripts(MathWordBuilder word, Converter conv, Field sup, Field sub) {
        boolean display;
        boolean bl = display = conv.getStyle() == 0;
        if (word.lastHasCollapsed() || !this.usingLimits(conv, display)) {
            return super.wordFinishingEggWithScripts(word, conv, sup, sub);
        }
        return this.makeEggWithScripts(this.nucleus.takeLastOperator(word, conv, display), conv, sup, sub);
    }

    private Egg makeEggWithScripts(Operator oper, Converter conv, Field sup, Field sub) {
        Dimen clr;
        Node body = oper.getNodeToBeLimited();
        Dimen width = body.getWidth();
        Node supNode = null;
        Node subNode = null;
        if (!sup.isEmpty()) {
            supNode = sup.cleanBox(conv, (byte)3);
            width = width.max(supNode.getWidth());
        }
        if (!sub.isEmpty()) {
            subNode = sub.cleanBox(conv, (byte)2);
            width = width.max(subNode.getWidth());
        }
        body = body.reboxedToWidth(width);
        Dimen height = body.getHeight();
        Dimen depth = body.getDepth();
        Dimen leftX = body.getLeftX();
        NodeList list = new NodeList();
        Dimen extra = conv.getDimPar(22);
        Dimen delta = oper.getItalCorr();
        if (delta != null) {
            delta = delta.halved();
        }
        if (supNode != null) {
            supNode = supNode.reboxedToWidth(width);
            leftX = leftX.max(supNode.getLeftX());
            clr = conv.getDimPar(20).minus(supNode.getDepth());
            clr = clr.max(conv.getDimPar(18));
            height = height.plus(extra).plus(supNode.getHeight()).plus(supNode.getDepth()).plus(clr);
            list.append(new IntVKernNode(extra));
            list.append(delta == null ? supNode : VShiftNode.shiftingRight(supNode, delta));
            list.append(new IntVKernNode(clr));
        }
        list.append(body);
        if (subNode != null) {
            subNode = subNode.reboxedToWidth(width);
            leftX = leftX.max(subNode.getLeftX());
            clr = conv.getDimPar(21).minus(subNode.getHeight());
            clr = clr.max(conv.getDimPar(19));
            depth = depth.plus(extra).plus(subNode.getHeight()).plus(subNode.getDepth()).plus(clr);
            list.append(new IntVKernNode(clr));
            list.append(delta == null ? subNode : VShiftNode.shiftingLeft(subNode, delta));
            list.append(new IntVKernNode(extra));
        }
        return new StSimpleNodeEgg(new VBoxNode(new BoxSizes(height, width, depth, leftX), GlueSetting.NATURAL, list), this.spacingType());
    }

    public OpNoad(Field nucleus, byte limits) {
        super(nucleus);
        this.limits = limits;
    }

    public OpNoad(Field nucleus) {
        super(nucleus);
        this.limits = (byte)2;
    }
}

