/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import nts.base.Dimen;
import nts.base.Num;
import nts.command.CommandBase;
import nts.command.CtrlSeqToken;
import nts.command.FileName;
import nts.command.PrefixPrim;
import nts.command.Token;
import nts.command.TokenList;
import nts.io.CharCode;
import nts.io.Name;
import nts.node.FontMetric;
import nts.typo.NullFontMetric;
import nts.typo.SetFont;
import nts.typo.TypoAssignPrim;
import nts.typo.TypoCommand;

public class FontPrim
extends TypoAssignPrim
implements TokenList.Provider {
    private static final Name NAME_FONT = Token.makeName("FONT");

    protected void assign(Token src, boolean glob) {
        CommandBase.ensureOpenLog();
        Token tok = PrefixPrim.definableToken();
        Name ident = this.makeIdent(tok);
        tok.define(NullFontMetric.COMMAND, glob);
        CommandBase.skipOptEquals();
        boolean inpEnbl = CommandBase.getConfig().enableInput(false);
        FileName name = CommandBase.scanFileName();
        Dimen size = this.scanSizeSpec();
        Num scale = size != null ? null : this.scanScaleSpec();
        CommandBase.getConfig().enableInput(inpEnbl);
        FontMetric metric = TypoCommand.getTypoHandler().getMetric(name, size, scale, ident, tok);
        if (metric != null) {
            tok.define(new SetFont(metric), glob);
        }
    }

    private Name makeIdent(Token tok) {
        Name ident = tok.controlName();
        if (ident == null) {
            CharCode code = tok.charCode();
            if (code != null) {
                Name.Buffer buf = new Name.Buffer(NAME_FONT.length() + 1);
                buf.append(NAME_FONT).append(code);
                ident = buf.toName();
            }
        } else if (ident.length() == 0) {
            ident = NAME_FONT;
        }
        return ident;
    }

    private Dimen scanSizeSpec() {
        Dimen size = null;
        if (!(!CommandBase.scanKeyword("at") || (size = CommandBase.scanDimen()).moreThan(0) && size.lessThan(2048))) {
            CommandBase.error("ImproperAt", CommandBase.str(size));
            size = Dimen.valueOf(10);
        }
        return size;
    }

    private Num scanScaleSpec() {
        Num scale = null;
        if (CommandBase.scanKeyword("scaled") && (!(scale = CommandBase.scanNum()).moreThan(0) || scale.moreThan(32768))) {
            CommandBase.error("IllegalMag", CommandBase.str(scale));
            scale = Num.valueOf(1000);
        }
        return scale;
    }

    public boolean hasFontTokenValue() {
        return true;
    }

    public boolean hasFontMetricValue() {
        return true;
    }

    public Token getFontTokenValue() {
        return new CtrlSeqToken(TypoCommand.getCurrFontMetric().getIdent());
    }

    public FontMetric getFontMetricValue() {
        return TypoCommand.getCurrFontMetric();
    }

    public FontPrim(String name) {
        super(name);
    }
}

