#define MAXLEN    256

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#ifdef __TURBOC__
#include <dir.h>
#else
#include <io.h>
#endif

#ifdef __TURBOC__
int main(int argc, char **argv)
#else
int main(int argc, const char **argv)
#endif
{
  FILE *infile, *outfile;
  char line[MAXLEN], *c;
  char emtexdir[MAXLEN], tfmdir[MAXLEN];
  char tempname[MAXLEN] = "ndvXXXXX";
  int  rc;

  if (argc <= 1)
    {
      printf("usage: mfjob <filename>\n");
      return(1);
    }
  if (strstr(argv[1], "dv") || strstr(argv[1], "DV"))
    {
      strcpy(emtexdir, ((c = getenv("EMTEXDIR")) != NULL) ? c : "C:\\EMTEX");
      if ((c = getenv("TEXTFM")) == NULL)
        {
          strcpy(tfmdir, emtexdir);
          strcat(tfmdir, "\\TFM");
        }
      else
        {
          strcpy(tfmdir, c);
          if ((c = strstr(tfmdir, ";")) != NULL)
            *c = '\0';
        }
      mktemp(tempname);
      strcat(tempname, ".mfj");
      if ((infile = fopen(argv[1], "r")) == NULL)
        {
          printf("cannot open input file.\n");
          return(1);
        }
      if ((outfile = fopen(tempname, "w")) == NULL)
        {
          printf("cannot open temporary file.\n");
          return(1);
        }
      while (fgets(line, MAXLEN, infile))
        {
          fputs(line, outfile);
          if (strnicmp("output", line, 6) == 0)
            {
              sprintf(line, "output=tfm[%s\\@f];\n", tfmdir);
              fputs(line, outfile);
            }
        }
      fclose(infile);
      fclose(outfile);
      argv[1] = tempname;
    }
  argv[0] = "mfjob.org";
  rc = spawnvp(P_WAIT, argv[0], argv);
  if (argv[1] == tempname)
    remove(tempname);
  return(rc);
}
