/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:     la_lrk_T.lex
dates:    17 Juin 2003	
Purpose:  lookahead expression lrk symbols recognizer that are unquoted
Returned: table entry
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |la_lrk_T| Thread.\fbreak
Recognize the meta terminals of LR K and returns them.
These are passed backed to the
calling grammar |la_expr_src|.

Added wolf in sheep's clothing: single and double quoted lrk strings.
|la_expr_src| corrected to arbitrate on subset / superset:
lrk string versus its general quoted string. 
@/
fsm	
(fsm-id	"la_lrk_T.lex",fsm-filename la_lrk_T,fsm-namespace NS_la_lrk_T
,fsm-class		Cla_lrk_T
,fsm-version "1.0",fsm-date "17 Juin 2003",fsm-debug "false"
,fsm-comments	"Unquoted lookahead source symbol recognizer.")
parallel-parser	
(	
  parallel-thread-function
    TH_la_lrk_T
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rla_lrk_T () {
  -> "|" "|" "|" {
  op
    CAbs_lr1_sym* sym = new LR1_parallel_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "\"" "|" "|" "|" "\"" {
  op
    CAbs_lr1_sym* sym = new LR1_parallel_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "'" "|" "|" "|" "'" {
  op
    CAbs_lr1_sym* sym = new LR1_parallel_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "|" "+" "|"  {
  op
    CAbs_lr1_sym* sym = new LR1_all_shift_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "\"" "|" "+" "|" "\"" {
  op
    CAbs_lr1_sym* sym = new LR1_all_shift_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "'" "|" "+" "|" "'" {
  op
    CAbs_lr1_sym* sym = new LR1_all_shift_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "|" "." "|"  {
  op
    CAbs_lr1_sym* sym = new LR1_invisible_shift_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "\"" "|" "." "|" "\""  {
  op
    CAbs_lr1_sym* sym = new LR1_invisible_shift_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "'" "|" "." "|" "'"  {
  op
    CAbs_lr1_sym* sym = new LR1_invisible_shift_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "|" "r" "|"  {
  op
    CAbs_lr1_sym* sym = new LR1_reduce_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "\"" "|" "r" "|" "\""  {
  op
    CAbs_lr1_sym* sym = new LR1_reduce_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "'" "|" "r" "|" "'"  {
  op
    CAbs_lr1_sym* sym = new LR1_reduce_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 

  -> "|" "t" "|"  {
  op
    CAbs_lr1_sym* sym = new LR1_fset_transience_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "\"" "|" "t" "|" "\""  {
  op
    CAbs_lr1_sym* sym = new LR1_fset_transience_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
  -> "'" "|" "t" "|" "'"  {
  op
    CAbs_lr1_sym* sym = new LR1_fset_transience_operator;
	sym->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
	RSVP(sym);
  ***
  } 
}
}// end of rules
