/*
  Copyright Dave Bone 1998 - 2014 
  All Rights Reserved. 
  No part of this document may be reproduced without written consent from the author.
	
FILE:		  term_def_ph.lex
Dates:		  24 Mar 2004
Purpose:	  parse terminal-def phrase
              Verifies if the symbol being defined is duplicate
              within yacco2's symbol table.
              Adds symbol to global symbol table.
Output:       Err_no_syntax_code_present
              Err_comment_overrun
              Err_no_identifier_present 
              Err_duplicate_directive 
              Err_no_close_brace
              Err_no_directive_present
              Err_already_defined_AB
              Err_already_defined_AD
              Err_dup_entry_in_sym_table
              Err_no_terminal_key_present
			  Err_bad_directive
*/
/@
@i "/usr/local/yacco2/copyright.w"
@** |term_def_ph| grammar.\fbreak
parse terminal-def phrase.
@/
fsm	
(fsm-id "term_def_ph.lex"
,fsm-filename term_def_ph
,fsm-namespace NS_term_def_ph
,fsm-class Cterm_def_ph{
  user-prefix-declaration
#include "lint_balls.h"
#include "identifier.h"
#include "c_string.h"
#include "t_def_delabort_tags.h"
#include "terminal_def_symclass.h"
#include "o2_sdc.h"
#include "yacco2_stbl.h"
#include "o2_externs.h"
#include "cweb_or_c_k.h"

  ***
  user-declaration
    public:
    void add_sdc_to_directive(CAbs_lr1_sym* Dir,T_syntax_code* Sdc);
    T_terminal_def* term_def_;
  ***
  user-implementation
    void Cterm_def_ph::
    add_sdc_to_directive(CAbs_lr1_sym* Dir,T_syntax_code* Sdc){
      using namespace NS_yacco2_T_enum;
      using namespace NS_yacco2_terminals;
      yacco2::INT eid = Dir->enumerated_id__;
      switch (eid){
		case T_Enum::T_T_user_declaration_: {
		  T_user_declaration* k = (T_user_declaration*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_constructor_: {
		  T_constructor* k = (T_constructor*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_destructor_: {
		  T_destructor* k = (T_destructor*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_op_: {
		  T_op* k = (T_op*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		case T_Enum::T_T_user_implementation_: {
		  T_user_implementation* k = (T_user_implementation*)Dir;
		  k->syntax_code(Sdc);
		  break;
		}      
		default: {
          CAbs_lr1_sym* sym = new Err_improper_directive;
          sym->set_rc(*Dir,__FILE__,__LINE__);
          RSVP_FSM(sym);
          parser__->set_stop_parse(true);
   		}      
      }    
    }
  ***
  op
    if(term_def_ != 0){
      delete term_def_;
      term_def_ = 0;
    }
    term_def_ = new T_terminal_def;
    term_def_->set_rc(*parser__->start_token__,__FILE__,__LINE__);
  ***
  constructor
      term_def_ = 0;
  ***
}
,fsm-version "1.0",fsm-date "24 mar 2004",fsm-debug "false"
,fsm-comments "Parse a terminal symbol.")
parallel-parser	
(	
  parallel-thread-function
    TH_term_def_ph
  ***
  parallel-la-boundary
    eolr
  ***
)
@"/usr/local/yacco2/compiler/grammars/yacco2_T_includes.T"

rules{
Rterminal_def_phrase  (){
  -> Rid Rlint Rad_ab_tags 
		 Rlint
         Rsym_cweb_k 
		 Rlint
         Ropen_par Rlint
             Rsym_class_phrase Rlint
             Rpotential_code_blk Rlint 
         Rclose_par Rlint {
    op
      Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
      RSVP(fsm->term_def_);
      // add to global symbol table
      const char* skey = fsm->term_def_->t_name()->c_str();
      T_sym_tbl_report_card report_card;
      T_in_stbl* tin = new T_in_stbl(fsm->term_def_
		,rule_info__.parser__->start_token__,rule_info__.parser__);
      STBL_T_ITEMS.push_back(tin);
      using namespace yacco2_stbl;
      add_sym_to_stbl(report_card,*skey,*tin,table_entry::defed,table_entry::terminal);
	  	if(report_card.status_ != T_sym_tbl_report_card::okay){
			report_card.err_entry_->set_rc(*rule_info__.parser__->start_token__,__FILE__,__LINE__);
			ADD_TOKEN_TO_ERROR_QUEUE(*report_card.err_entry_);
			rule_info__.parser__->set_stop_parse(true);
			return;
		}
	  tin->stbl_idx(report_card.pos_);
      fsm->term_def_ = 0;
    ***
    }	
}

Rid  (){
  ->  ||| "c-string" NS_c_string::TH_c_string {
      op 
        Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
        const char* skey = sf->p2__->c_string()->c_str();
        fsm->term_def_->t_name(skey);
        sf->p2__->set_auto_delete(true);
        T_sym_tbl_report_card report_card;
        using namespace yacco2_stbl;
        find_sym_in_stbl(report_card,*skey);
        if(report_card.action_ == T_sym_tbl_report_card::fnd){
          CAbs_lr1_sym* sym = new Err_dup_entry_in_sym_table;
          sym->set_rc(*sf->p2__,__FILE__,__LINE__);
          RSVP(sym);
          rule_info__.parser__->set_stop_parse(true);
          return;
        }
      ***
      }
  ->  ||| identifier NS_identifier::TH_identifier {
      op 
        Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
        const char* skey = sf->p2__->identifier()->c_str();
        fsm->term_def_->t_name(skey);
        sf->p2__->set_auto_delete(true);
      ***
      } 
  ->  ||| "T-in-stbl" NULL {
      op 
          CAbs_lr1_sym* sym = new Err_dup_entry_in_sym_table;
          sym->set_rc(*sf->p2__,__FILE__,__LINE__);
          RSVP(sym);
          rule_info__.parser__->set_stop_parse(true);
          return;
      ***
      }     
  -> ||| |?| NULL { 
      op 
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  -> ||| "#lrk-sufx" NULL { 
      op 
        sf->p2__->set_auto_delete(true);
        rule_info__.parser__->set_abort_parse(true);
      ***
      }
  -> ||| "#terminals-sufx" NULL { 
      op 
        sf->p2__->set_auto_delete(true);
        rule_info__.parser__->set_abort_parse(true);
      ***
      }
  -> ||| "#terminals-refs" NULL { 
      op 
          sf->p2__->set_auto_delete(true);
        rule_info__.parser__->set_abort_parse(true);
      ***
      }
}

Rad_ab_tags  (){
  ->  Rad_ab_tag Rlint  
  ->  Rad_ab_tags Rad_ab_tag Rlint
  ->    
}

Rad_ab_tag  (){
  ->  ||| "#AD" NS_t_def_delabort_tags::TH_t_def_delabort_tags {
      op 
        Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
        if(fsm->term_def_->autodelete() == true){
			CAbs_lr1_sym* sym = new Err_already_defined_AD;
			sym->set_rc(*sf->p2__,__FILE__,__LINE__);
			RSVP(sym);
			rule_info__.parser__->set_stop_parse(true);
			return;
        }
        fsm->term_def_->autodelete(true);
      ***
      }
  ->  ||| "#AB" NULL {
      op 
        Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
        if(fsm->term_def_->autoabort() == true){
			CAbs_lr1_sym* sym = new Err_already_defined_AB;
			sym->set_rc(*sf->p2__,__FILE__,__LINE__);
			RSVP(sym);
			rule_info__.parser__->set_stop_parse(true);
			return;
        }
        fsm->term_def_->autoabort(true);
      ***
      }
}

Rsym_cweb_k  (){
  -> 
  ->  ||| "cweb-comment" NS_cweb_or_c_k::TH_cweb_or_c_k {
  op
        Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
      T_cweb_comment* k = sf->p2__;
      AST* cwebk_t_ = new AST(*k);

      AST* cweb_t_ = new AST();
      T_cweb_marker* cw = new T_cweb_marker(cweb_t_);
      AST::set_content(*cweb_t_,*cw);
        AST::join_pts(*cweb_t_,*cwebk_t_);

      cw->set_rc(*k,__FILE__,__LINE__);
      AST::set_content(*cweb_t_,*cw);
        fsm->term_def_->add_cweb_marker(cw->ast());
  ***
  }
  ->  ||| |?| NULL {
      op 
		RSVP(sf->p2__);
		rule_info__.parser__->set_stop_parse(true); 
      ***
      }     
}

Rsym_class_phrase  (){
  ->  Rsym_class Rlint Rsym_class_id
}

Rsym_class  (){
  ->  ||| "#sym-class" NS_terminal_def_symclass::TH_terminal_def_symclass 
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_sym_class_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rsym_class_id  (){
  ->  ||| identifier NS_identifier::TH_identifier {
      op 
        Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
        fsm->term_def_->classsym(sf->p2__->identifier()->c_str());
        sf->p2__->set_auto_delete(true);
      ***
      } 
  -> ||| |?| NULL { 
      op
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_no_sym_class_id_present;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  |?| {
      op
        CAbs_lr1_sym* sym = new Err_no_sym_class_id_present;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rpotential_code_blk  (){
  ->   
  ->  "{" Rlint Rdirectives Rlint Rclosing_brace Rlint
}

Ropen_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_open_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "("
}

Rclose_par  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_parenthesis;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  ")"
}

Rclosing_brace  (){
  ->  |?| { 
      op
        CAbs_lr1_sym* sym = new Err_no_close_brace;
        sym->set_rc(*rule_info__.parser__->current_token(),__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
  ->  "}"
}

Rdirectives  (){ 
  -> Rdirective Rsyntax_code Rlint {
    op
      Rdirective* dir = sf->p1__;
      Rsyntax_code* sdc = sf->p2__;
      Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    } 
  -> Rdirectives Rdirective Rsyntax_code Rlint {
    op
      Rdirective* dir = sf->p2__;
      Rsyntax_code* sdc = sf->p3__;
      Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
      fsm->add_sdc_to_directive(dir->directive_,sdc->syntax_code_);
    ***
    }
}

Rdirective  (
lhs {
  user-declaration
    CAbs_lr1_sym* directive_;
  ***
  op
    if(directive_ == 0) return;
    Cterm_def_ph* fsm = (Cterm_def_ph*)rule_info__.parser__->fsm_tbl__;
    CAbs_lr1_sym* result = 
	fsm->term_def_->add_directive_to_map(directive_,rule_info__.parser__);
    if(result == 0) return;// ok added
    directive_->set_auto_delete(true);//dup: delete when popped from stack
    RSVP(result);
    rule_info__.parser__->set_stop_parse(true);
  ***
 } 
){ 
  ->  ||| "#user-declaration" NS_identifier::TH_identifier { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#user-implementation" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#constructor" NULL { 
      op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#destructor" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  ->  ||| "#op" NULL { 
    op
      directive_ = sf->p2__;
    ***
    }
  -> ||| |?| NULL { 
      op
		directive_ = 0;
        sf->p2__->set_auto_delete(true);
        CAbs_lr1_sym* sym = new Err_bad_directive;
        sym->set_rc(*sf->p2__,__FILE__,__LINE__);
        RSVP(sym);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rsyntax_code  (
lhs {
  user-declaration
    T_syntax_code* syntax_code_;
  ***
 } 
){
  -> ||| "syntax-code" NS_o2_sd::TH_o2_sdc {
      op
        syntax_code_ = sf->p2__;
      ***
      }
  -> ||| |?| NULL { // catcher in the Rye? These are errors
      op
		syntax_code_ = 0;
        RSVP(sf->p2__);
        rule_info__.parser__->set_stop_parse(true);
      ***
      }
}

Rlint  (){
  ->  ||| lint NS_lint_balls::TH_lint_balls
  -> 
}
}// end of rules
