@q file: testout_includes.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
@*1 Include files.\fbreak 
To start things off, these are the Standard Template Library (STL) containers 
needed by Yacco2's parse library definitions.
@<Include files@>=
#include "testout.h" 
 
@*2 Create header file for testout environment.\fbreak
The include files format is:\fbreak
\ptindent{1) system related definitions}
\ptindent{2) the grammar vocabulary framework}
\ptindent{3) grammars used}
\ptindent{4) namespace use for convenience in your \Cpp{} code}
Note the namespace turn-ons for Error and Meta-terminal vocabularies.
Your own language will define your vocabularies with their own namespaces.
Have a look at their definition files: |testout_err_symbols.T|
and |testout_terminals.T| and possibly re-read ``o2book.pdf'' for a refresher on their Ws.
This example is skeletal for teaching purposes whereas your own vocabulary will be meater.
Also note the 2 grammar headers: |pager_1.h| and the error handler |testout_err_hdlr.h|.
@(testout.h@>=
@h
#ifndef testout__
#define testout__ 1
#include <stdarg.h> 
#include <stdlib.h> 
#include <string.h> 
#include <limits.h> 

#include "yacco2.h"
#include "testout_T_enumeration.h"
#include "yacco2_characters.h"
#include "yacco2_k_symbols.h"
#include "testout_terminals.h"
#include "testout_err_symbols.h"
#include "pager_1.h"
#include "testout_err_hdlr.h"

using namespace std;
using namespace NS_testout_T_enum;
using namespace NS_yacco2_k_symbols;
using namespace NS_testout_terminals;
using namespace NS_testout_err_symbols;
using namespace yacco2;
#endif
