@q file: constants.w@>
@q%   Copyright Dave Bone 1998 - 2015@>
@q% /*@>
@q%    This Source Code Form is subject to the terms of the Mozilla Public@>
@q%    License, v. 2.0. If a copy of the MPL was not distributed with this@>
@q%    file, You can obtain one at http://mozilla.org/MPL/2.0/.@>
@q% */@>
@** Constant definitions.\fbreak
These are used by a hodge-podge of functionalities.
The majority of the constants are enumerates:
|LR1_Questionable_operator| to
|LR1_Procedure_call_operator|are the lr constants. 
Some individual  definitions below have comments relating their grammar's logical symbol.
I did this as a memory jog to read the grammars.
For example, to introduce parallelism into the grammar, the \PARshift symbol
is used.
These constants allow one to efficiently test against an
abstract symbol for its appropriate identity.
Why test its identity?: to cast to a concrete object or to do conditional processing.
Why not use \CPLUSPLUS/ cast type operators --- just too expensive in space and time!
This is not a complaint but expressed from experience
with Yacco2's environment ---
lots and lots of symbols and type cast operators lead to `fat city'. 

All grammar symbols (terminals and rules) have an emitted enumeration definition.
The reason for these hardwired definitions is that they are 
also referenced within the Yacco2 compiler/compiler before I bootstrapped 
Yacco2 to compile its own grammars.
These symbols will be explained when the code is developed.
Possibly as I recast Yacco2 into |cweb|, these constants could be dropped
for their generated look-alikes.
Until then, they have earned their keep.
 
@ Enumerates. Events.
@d FORCE_STK_TRACE 0
@d COND_STK_TRACE 1
@d Accept_parallel_parse           1
@d Shutdown                        2
@d LR1_Questionable_operator    0 // \QUEshift
@d LR1_Eog                         1
@d LR1_Eolr                        2
@d LR1_Parallel_operator           3 // \PARshift
@d LR1_Reduce_operator             4 // \REDshift
@d LR1_Invisible_shift_operator    5 // \INVshift
@d LR1_All_shift_operator          6 // \ALLshift
@d LR1_FSET_transience_operator    7 // \TRAshift
@d LR1_Procedure_call_operator    7 // \PROCshift

@ The only reason for this section is to stop the appended slash to the last |cweb| macro above.
This is a slight deviation in |cweb| code emission. 
Another abnormality is the use of the word ``error'' within \CPLUSPLUS/ code: eg. enums.
|cweb| has a slight clearing of the throat. So, just rename ``error'' to some other form: err ... 
